/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.overlay.core.v2_1;

import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.datamodels.v2_1.DataModelConstants;
import com.roguewave.chart.overlay.core.v2_1.DataRange;

public class AllRowsDataRange
implements DataRange,
DataModelConstants {
    private boolean lowFlag_ = true;

    public AllRowsDataRange() {
    }

    public AllRowsDataRange(boolean lowFlag) {
        this.lowFlag_ = lowFlag;
    }

    public double high(DataModel data) {
        int columns = data.getColumnCount();
        double high = data.getValue(0, 0);
        for (int row = 0; row < data.getRowCount(); ++row) {
            for (int i = 0; i < columns; ++i) {
                double value = data.getValue(row, i);
                if (value == Double.NEGATIVE_INFINITY || !(value > high) && high != Double.NEGATIVE_INFINITY) continue;
                high = value;
            }
        }
        return high;
    }

    public double low(DataModel data) {
        int columns = data.getColumnCount();
        double low = data.getValue(0, 0);
        for (int row = 0; row < data.getRowCount(); ++row) {
            for (int i = 0; i < columns; ++i) {
                double value = data.getValue(row, i);
                if (value == Double.NEGATIVE_INFINITY || !(value < low) && low != Double.NEGATIVE_INFINITY) continue;
                low = value;
            }
        }
        if (this.lowFlag_ && low > 0.0) {
            return 0.0;
        }
        return low;
    }

    public boolean getLowValueMode() {
        return this.lowFlag_;
    }

    public void setLowValueMode(boolean mode) {
        this.lowFlag_ = mode;
    }
}

